<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../../componenti/include/includeBaseComponenti.php";
    // solo i super admin hanno accesso agli strumenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";

    $parametriRicerca = $cerca!="" ? array("prodotto"=>"Doc","testo"=>$cerca) : array("prodotto"=>"Doc");
    $parametri = array("tabella"=>"geec_elementoStoricoOperazioni", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Amministrazione di Geecom Doc - storico operazioni</title>

    <?php
        include "../../componenti/include/cssBaseComponenti.php";
    ?>
	  
  </head>
  <body>
    
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
	  
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==200) {
                                echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Storico operazioni svuotato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>";
                            }
                        }
                    ?>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="panel panel-default">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span class="card-title align-self-center my-0 mr-2">Storico operazioni pagine</span>
                                <a href="../../../controller/controllerImpostazioni.php?operazione=svuotaStoricoOperazioni" class="btn btn-sm btn-danger ml-auto">
                                    Svuota<i class="fas fa-trash-alt ml-2"></i>
                                </a>
                            </div>
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="table-responsive p-1">
                                    <table id="example" class="table table-striped table-hover" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Tipo</th>
                                                <th>Testo</th>
                                                <th>Data</th>
                                                <th>Azioni</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                       
                                            if(isset($_GET["pag"])) {
                                                $ricerca->eseguiRicerca($_GET["pag"]);
                                            }
                                            else {
                                                $ricerca->eseguiRicerca(1);
                                            }

                                            $result = $ricerca->getRisultatoQueryRicerca();
                                            while($elementoStorico=$result->fetch_assoc()) {
                                                $testoEscape = filter_var($elementoStorico["testo"],FILTER_SANITIZE_ADD_SLASHES);
                                                $dataCreazione = date("d/m/Y H:i",strtotime($elementoStorico["dataCreazione"]));
                                                echo"<tr id=\"ricaElementoStorico{$elementoStorico["id"]}\">
                                                <td>{$elementoStorico["id"]}</td>
                                                <td>{$elementoStorico["tipo"]}</td>
                                                <td>{$elementoStorico["testo"]}</td>
                                                <td>{$dataCreazione}</td>
                                                <td><div class=\"btn-group azioni\" role=\"group\" aria-label=\"Azioni\">
                                                    <a  class=\"btn elimina\" href=\"#\" onclick=\"eliminaElementoStorico({$elementoStorico["id"]},'{$testoEscape}')\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\"><i class=\"far fa-trash-alt\"></i> </a>";
                                                echo"</div>
                                                    </td>
                                              </tr>";
                                            }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php
                                    $ricerca->stampaPaginazione("index.php?pag=");
                                ?>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
    ?>
        <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare l'utente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="elementoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneElementoStorico()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
    <?php
        include "../../componenti/include/jsBaseComponenti.php";
        
    ?>
        <script>
            
            function eliminaElementoStorico(id,nome) {
                document.getElementById("elementoDaEliminare").value = id;
                document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
                $('#modalEliminaElemento').modal('show');
            }

            function eseguiEliminazioneElementoStorico() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerStoricoOperazioni.php",
                    data:{
                        operazione:"eliminaElementoStorico",
                        id:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("ricaElementoStorico"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
	  
  </body>
</html>
